#!/usr/bin/env python
# *-* encoding: utf8 *-*
import pyfirmata
from Tkinter import *

arduinoboard = pyfirmata.Arduino('/dev/ttyACM0')

it = pyfirmata.util.Iterator(arduinoboard)
it.start()

pin3 = arduinoboard.get_pin('d:3:s') # Broche 3 en mode servo

def cleanup():
    # Broche 3 désactivée
    pin3.write(0)
    arduinoboard.exit()

def moveServo(a):
    # La broche 3 est en mode servo
    pin3.write(a)

# GUI Interface graphique
master = Tk()
master.wm_protocol("WM_DELETE_WINDOW", cleanup)
master.wm_title('Servo-Control')

# Initialisation du potentiomètre linéaire
scale = Scale(master,
    from_ = 0,
    to = 179,
    command = moveServo,
    orient = HORIZONTAL,
    length = 400,
    label = 'Angle')

scale.pack(anchor = CENTER) # Placer au milieu
mainloop()                  # Démarrage de la boucle d'interrogation Tk